function ScreenTriangleSystem(){

	this.triangles=[];
	

}

ScreenTriangleSystem.prototype.defineTriangle = function(x1,y1,x2,y2,x3,y3,rx,ry,rz,fx,fy){
	
	this.triangles.push(new ScreenTriangle(x1,y1,x2,y2,x3,y3));
	this.triangles[this.triangles.length-1].increaseRotationX=rx;
	this.triangles[this.triangles.length-1].increaseRotationY=ry;
	this.triangles[this.triangles.length-1].increaseRotationZ=rz;
	this.triangles[this.triangles.length-1].offsetfunc_x=fx;
	this.triangles[this.triangles.length-1].offsetfunc_y=fy;

}

ScreenTriangleSystem.prototype.computeTriangles = function(image){

	for(var i=0;i<this.triangles.length;i++){
			
		this.triangles[i].computeImage(image);
		
	}

}

ScreenTriangleSystem.prototype.blit = function(x,y,a){
	
	for(var i=0;i<this.triangles.length;i++){
		if(a!=undefined)this.triangles[i].color.alpha=a;
		this.triangles[i].blit(x,y);
		
	}

}

ScreenTriangleSystem.prototype.frameSkip = function(){
	
	for(var i=0;i<this.triangles.length;i++){
		
		this.triangles[i].frameSkip();
		
	}

}



ScreenTriangleSystem.prototype.blitColorTriangle = function(tr_index,color){
	
	if(this.triangles.length<=tr_index)return;
	this.triangles[tr_index].blitColorTriangle(color);

}

ScreenTriangleSystem.prototype.countTriangles = function(){
	
	return this.triangles.length;

}



///////////////////////////////////////////////////////////////

function ScreenTriangle(x1,y1,x2,y2,x3,y3){
	
	this.offsetx=0;
	this.offsety=0;
	this.p1=[x1,y1];
	this.p2=[x2,y2];
	this.p3=[x3,y3];
	this.surface=undefined;
	this.image=undefined;
	
	this.rotationX=0;
	this.rotationY=0;
	this.rotationZ=0;
	
	this.increaseRotationX=0;
	this.increaseRotationY=0;
	this.increaseRotationZ=0;
	
	this.maskAlpha=CreateColor(255,0,0,0);
	this.color = CreateColor(255,255,255,255);
	this.bbw=0;
	this.bbh=0;
	
	this.offsetfunc_x=function(x){}
	this.offsetfunc_y=function(y){}
	


}

ScreenTriangle.prototype.computeImage = function(image){
	
	
	this.surface = image.createSurface();
	
	
	with(this){	
		var minx=Math.min(Math.min(p1[0],p2[0]),p3[0]);
		var miny=Math.min(Math.min(p1[1],p2[1]),p3[1]);
		var minw=Math.max(Math.max(p1[0],p2[0]),p3[0])-minx;
		var minh=Math.max(Math.max(p1[1],p2[1]),p3[1])-miny;
	}
	this.surface = this.surface.cloneSection(minx,miny,minw,minh);
	this.surface.setBlendMode(REPLACE);
	this.offsetx+=minx;
	this.offsety+=miny;
	
	this.p1[0]-=minx;
	this.p2[0]-=minx;
	this.p3[0]-=minx;
	this.p1[1]-=miny;
	this.p2[1]-=miny;
	this.p3[1]-=miny;
	
	this.bbw = minw;
	this.bbh = minh;
	
	with(this){	
		
		/*if(
			p1[0]==0||p1[0]==bbw&&
			p2[0]==0||p2[0]==bbw&&
			p3[0]==0||p3[0]==bbw&&
			p1[1]==0||p1[1]==bbh&&
			p2[1]==0||p2[1]==bbh&&
			p3[1]==0||p3[1]==bbh
			)	
			surface.triangle(
				Math.abs(p1[0]-bbw),
				Math.abs(p1[1]-bbh),
				Math.abs(p2[0]-bbw),
				Math.abs(p2[1]-bbh),
				Math.abs(p3[0]-bbw),
				Math.abs(p3[1]-bbh),
				maskAlpha);
		else{*/
		
			var fx=0,fy=0;
			
			if(p1[0]==0&&p2[1]==0){
				fx=0;
				fy=0;
				}
			else if(p1[0]==0&&p2[1]==minh){
				fx=0;
				fy=minh;
				}
			else if(p1[0]==minw&&p2[1]==0){
				fx=minw;
				fy=0;
				}
			else if(p1[0]==minw&&p2[1]==minh){
				fx=minw;
				fy=minh;
				}
			else if(p2[0]==0&&p1[1]==0){
				fx=0;
				fy=0;
				}
			else if(p2[0]==0&&p1[1]==minh){
				fx=0;
				fy=minh;
				}
			else if(p2[0]==minw&&p1[1]==0){
				fx=minw;
				fy=0;
				}
			else if(p2[0]==minw&&p1[1]==minh){
				fx=minw;
				fy=minh;
				}
			surface.triangle(p1[0],p1[1],p2[0],p2[1],fx,fy,maskAlpha);
			
			if(p1[0]==0&&p3[1]==0){
				fx=0;
				fy=0;
				}
			else if(p1[0]==0&&p3[1]==minh){
				fx=0;
				fy=minh;
				}
			else if(p1[0]==minw&&p3[1]==0){
				fx=minw;
				fy=0;
				}
			else if(p1[0]==minw&&p3[1]==minh){
				fx=minw;
				fy=minh;
				}
			else if(p3[0]==0&&p1[1]==0){
				fx=0;
				fy=0;
				}
			else if(p3[0]==0&&p1[1]==minh){
				fx=0;
				fy=minh;
				}
			else if(p3[0]==minw&&p1[1]==0){
				fx=minw;
				fy=0;
				}
			else if(p3[0]==minw&&p1[1]==minh){
				fx=minw;
				fy=minh;
				}
			surface.triangle(p1[0],p1[1],p3[0],p3[1],fx,fy,maskAlpha);
			
			if(p3[0]==0&&p2[1]==0){
				fx=0;
				fy=0;
				}
			else if(p3[0]==0&&p2[1]==minh){
				fx=0;
				fy=minh;
				}
			else if(p3[0]==minw&&p2[1]==0){
				fx=minw;
				fy=0;
				}
			else if(p3[0]==minw&&p2[1]==minh){
				fx=minw;
				fy=minh;
				}
			else if(p2[0]==0&&p3[1]==0){
				fx=0;
				fy=0;
				}
			else if(p2[0]==0&&p3[1]==minh){
				fx=0;
				fy=minh;
				}
			else if(p2[0]==minw&&p3[1]==0){
				fx=minw;
				fy=0;
				}
			else if(p2[0]==minw&&p3[1]==minh){
				fx=minw;
				fy=minh;
				}
			surface.triangle(p3[0],p3[1],p2[0],p2[1],fx,fy,maskAlpha);
			}
		
	
	this.image=this.surface.createImage();
	delete this.surface;
		
}

ScreenTriangle.prototype.blit = function(x,y){
	
	with(this){
		
		var md = Math.sqrt(bbw/2 * bbw/2 + bbh/2 * bbh/2);
		
		
		
		//color.red = color.green = color.blue = (rotationX+90)/180*256;
				
		image.transformBlitMask(
			offsetx+x +bbw/2+(Math.sin(         Math.asin((bbh/2)/md) + (-90+rotationZ)*Math.PI/180))*md*Math.sin((90+rotationY)*Math.PI/180),
			offsety+y +bbh/2+(Math.cos(         Math.asin((bbh/2)/md) + ( 90+rotationZ)*Math.PI/180))*md*Math.cos((rotationX)*Math.PI/180),
			offsetx+x +bbw/2+(Math.sin(Math.PI -Math.asin((bbh/2)/md) + (-90+rotationZ)*Math.PI/180))*md*Math.sin((90+rotationY)*Math.PI/180),
			offsety+y +bbh/2+(Math.cos(Math.PI -Math.asin((bbh/2)/md) + ( 90+rotationZ)*Math.PI/180))*md*Math.cos((rotationX)*Math.PI/180),
			offsetx+x +bbw/2+(Math.sin(Math.PI +Math.asin((bbh/2)/md) + (-90+rotationZ)*Math.PI/180))*md*Math.sin((90+rotationY)*Math.PI/180),
			offsety+y +bbh/2+(Math.cos(Math.PI +Math.asin((bbh/2)/md) + ( 90+rotationZ)*Math.PI/180))*md*Math.cos((rotationX)*Math.PI/180),
			offsetx+x +bbw/2+(Math.sin(        -Math.asin((bbh/2)/md) + (-90+rotationZ)*Math.PI/180))*md*Math.sin((90+rotationY)*Math.PI/180),
			offsety+y +bbh/2+(Math.cos(        -Math.asin((bbh/2)/md) + ( 90+rotationZ)*Math.PI/180))*md*Math.cos((rotationX)*Math.PI/180),
			color);
			
			rotationX+=increaseRotationX;
			rotationY+=increaseRotationY;
			rotationZ+=increaseRotationZ;
			
			offsetx=offsetfunc_x(offsetx);
			offsety=offsetfunc_y(offsety);
			
			}
		
}

ScreenTriangle.prototype.frameSkip = function(){
	
	with(this){
		
		
			rotationX+=increaseRotationX;
			rotationY+=increaseRotationY;
			rotationZ+=increaseRotationZ;
			
			offsetx=offsetfunc_x(offsetx);
			offsety=offsetfunc_y(offsety);
			
			}
		
}


ScreenTriangle.prototype.blitColorTriangle = function(clr){

	with(this){
		Triangle(	offsetx+p1[0],
							offsety+p1[1],
							offsetx+p2[0],
							offsety+p2[1],
							offsetx+p3[0],
							offsety+p3[1],
							color);
	}

}
////////////////////////////////////PRESETS

function ScreenTriangleSystemPreset_Wind01(front,back){
	var size=160;
	var ts = new ScreenTriangleSystem();
	var x=GetScreenWidth()-size;
	var func_x=function(fx){fx-=(GetScreenWidth()-fx)/200;return fx;}
	var func_y=function(fy){fy-=(GetScreenHeight()-fy-GetScreenHeight()/2)/500;return fy;}
	var white = CreateColor(255,255,255);
	
	do{
		front.blit(0,0);
		
		for(var y=0;y<GetScreenHeight();y+=size){
			ts.defineTriangle(x,y,x+size,y,x,y+size,Math.random()*10-5,0,Math.random()*10-5,func_x,func_y);
			Line(x,y,x+size,y,white);
			Line(x+size,y,x,y+size,white);
			Line(x,y+size,x,y,white);
			
			ts.defineTriangle(x,y+size,x+size,y,x+size,y+size,Math.random()*10-5,0,Math.random()*10-5,func_x,func_y);
			Line(x+size,y+size,x+size,y,white);
			Line(x+size,y,x,y+size,white);
			Line(x,y+size,x+size,y+size,white);
		}
		x-=size;
		
		FlipScreen();
		
		
	
	}while(x>=0)
	front.blit(0,0);
	FlipScreen();
	
	ts.computeTriangles(front);
	GarbageCollect();
	
	var a=255;
	
	while(a>254){
		
		back.blit(0,0);
		Rectangle(0,0,GetScreenWidth(),GetScreenHeight(),white);
		ts.blit(0,0,a);
		ts.blit(a-255,0,a);
		if(a>0)a-=1;
		FlipScreen();
	}
	GetKey();
	while(a>0){
		white.alpha=Math.max(0,a*2-255);
		back.blit(0,0);
		Rectangle(0,0,GetScreenWidth(),GetScreenHeight(),white);
		ts.blit(a-255,0,a);
		ts.blit(0,0,a);
		ts.blit(a-255,0,a);
		if(a>0)a-=10;
		FlipScreen();
	}
	
}
/////////////////////////////////////////////

function ScreenTriangleSystemPreset_Crack01(front,back){
	var tm = new TimeMonitor();
	var size=160;
	var crack = objectsystem.image.get("effekt/e_screen_crack.png");
	var snd_crk = objectsystem.sound.get("sfx/glass_crack.wav");
	var snd_crs = objectsystem.sound.get("sfx/glass_crush.wav");
	var ts = new ScreenTriangleSystem();
	var x=GetScreenWidth()-size;
	var func_x=function(fx){fx-=(GetScreenWidth()-fx-GetScreenWidth()/2)/200;return fx;}
	var func_y=function(fy){fy-=(GetScreenHeight()-fy-GetScreenHeight()/2)/500;return fy;}
	var white = CreateColor(255,255,255);
	
	
	front.blit(0,0);
	crack.blit(0,0);
	
	
	var front_2=GrabImage(0,0,640,480);
	
	
	
	ts.defineTriangle(0,0,250,0,314,255,			Math.random()*2-1,0,Math.random()*2-1,func_x,func_y);
	ts.defineTriangle(250,0,640,0,478,103,		Math.random()*2-1,0,Math.random()*2-1,func_x,func_y);
	ts.defineTriangle(640,63,640,0,478,103,		Math.random()*2-1,0,Math.random()*2-1,func_x,func_y);
	ts.defineTriangle(478,103,314,255,640,63,	Math.random()*2-1,0,Math.random()*2-1,func_x,func_y);
	ts.defineTriangle(250,0,478,103,314,255,	Math.random()*2-1,0,Math.random()*2-1,func_x,func_y);
	ts.defineTriangle(640,63,314,255,640,268,	Math.random()*2-1,0,Math.random()*2-1,func_x,func_y);
	ts.defineTriangle(314,255,640,268,640,406,Math.random()*2-1,0,Math.random()*2-1,func_x,func_y);
	ts.defineTriangle(369,480,640,406,640,480,Math.random()*2-1,0,Math.random()*2-1,func_x,func_y);
	ts.defineTriangle(369,480,640,406,314,255,Math.random()*2-1,0,Math.random()*2-1,func_x,func_y);
	ts.defineTriangle(198,480,314,255,369,480,Math.random()*2-1,0,Math.random()*2-1,func_x,func_y);
	ts.defineTriangle(0,480,198,480,314,255,	Math.random()*2-1,0,Math.random()*2-1,func_x,func_y);
	ts.defineTriangle(175,353,0,480,0,375,		Math.random()*2-1,0,Math.random()*2-1,func_x,func_y);
	ts.defineTriangle(0,200,0,375,175,353,		Math.random()*2-1,0,Math.random()*2-1,func_x,func_y);
	ts.defineTriangle(0,200,175,353,314,255,	Math.random()*2-1,0,Math.random()*2-1,func_x,func_y);
	ts.defineTriangle(314,255,0,0,0,200,			Math.random()*2-1,0,Math.random()*2-1,func_x,func_y);
	
	ts.computeTriangles(front_2);
	GarbageCollect();
	
	
	for(var i=0;i<ts.countTriangles();i++){
			
			front.blit(0,0);
			ts.blitColorTriangle(i,white);
			FlipScreenFps();
			
		}
	
	
	var a=255;
	
	while(a>254){
		
		back.blit(0,0);
		Rectangle(0,0,GetScreenWidth(),GetScreenHeight(),white);
		ts.blit(0,0,a/10);
		ts.blit(0,0,a);
		
		if(a>0)a-=1;
		FlipScreenFps();
	}
	var tmpt=GetTime();
	snd_crk.play(false);
	while(GetTime()-tmpt<1000);
	snd_crs.play(false);
	
	/*OLD
	var fliptime=13;
	while(a>0){
		white.alpha=Math.max(0,a*2-255);
		back.blit(0,0);
		Rectangle(0,0,GetScreenWidth(),GetScreenHeight(),white);
		if(fliptime<=19)ts.blit(0,0,a/4);
		else ts.frameSkip();
		if(fliptime<=17)ts.blit(0,0,a/2);
		else ts.frameSkip();
		ts.blit(0,0,a);
		if(a>0)a-=10;
		fliptime=FlipScreenFps();
	}
	*/
	var fliptime=13;
	tm.setLength(1000);
	tm.start();
	var tmptime=0;
	while((tmptime=tm.getPercent())<100){
		a=((100-tmptime)/100*255);
		white.alpha=Math.max(0,a*2-255);
		back.blit(0,0);
		Rectangle(0,0,GetScreenWidth(),GetScreenHeight(),white);
		if(fliptime<=19)ts.blit(0,0,a/4);
		else ts.frameSkip();
		if(fliptime<=17)ts.blit(0,0,a/2);
		else ts.frameSkip();
		ts.blit(0,0,a);
		if(a>0)a-=10;
		fliptime=FlipScreenFps();
		}
	
}